<?php
$dir = __DIR__;
$files = glob($dir . '/reservation-*.txt');

// Sort newest first
usort($files, function($a, $b) {
    return filemtime($b) - filemtime($a);
});

function parseReservation($content) {
    $data = [];
    $lines = explode("\n", $content);
    foreach ($lines as $line) {
        if (stripos($line, "Nom du Parent:") === 0) $data['Parent'] = trim(substr($line, 14));
        if (stripos($line, "Email:") === 0) $data['Email'] = trim(substr($line, 6));
        if (stripos($line, "Nom de l'Enfant:") === 0) $data['Enfant'] = trim(substr($line, 15));
        if (stripos($line, "Âge de l'Enfant:") === 0) $data['Âge'] = trim(substr($line, 17));
        if (stripos($line, "Forfait:") === 0) $data['Forfait'] = trim(substr($line, 8));
        if (stripos($line, "Activités Préférées:") === 0) $data['Activités'] = trim(substr($line, 20));
        if (stripos($line, "Notes:") === 0) $data['Notes'] = trim(substr($line, 6));
        if (stripos($line, "Date/Heure:") === 0) $data['Date'] = trim(substr($line, 11));
        if (stripos($line, "IP:") === 0) $data['IP'] = trim(substr($line, 3));
    }
    return $data;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Liste des Réservations</title>
  <style>
    body { font-family: Arial, sans-serif; background: #f4f6f8; padding: 30px; }
    h1 { text-align: center; color: #222; margin-bottom: 30px; }
    .card {
        background: #fff;
        border-radius: 8px;
        padding: 20px;
        margin: 15px auto;
        max-width: 800px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .header {
        display: flex;
        justify-content: space-between;
        margin-bottom: 15px;
    }
    .header strong { font-size: 1.2em; color: #0077cc; }
    table {
        width: 100%;
        border-collapse: collapse;
    }
    td {
        padding: 6px 8px;
        border-bottom: 1px solid #eee;
    }
    td:first-child {
        font-weight: bold;
        color: #555;
        width: 180px;
    }
    .notes {
        background: #f9f9f9;
        padding: 10px;
        border-radius: 5px;
        margin-top: 10px;
        font-style: italic;
        color: #666;
    }
  </style>
</head>
<body>
  <h1>📋 Réservations</h1>

  <?php if (empty($files)): ?>
    <p style="text-align:center; color:#888;">Aucune réservation trouvée.</p>
  <?php else: ?>
    <?php foreach ($files as $file): 
        $parsed = parseReservation(file_get_contents($file));
    ?>
      <div class="card">
        <div class="header">
          <strong><?= htmlspecialchars($parsed['Parent'] ?? 'Inconnu') ?></strong>
          <span><?= htmlspecialchars($parsed['Date'] ?? '') ?></span>
        </div>
        <table>
          <tr><td>Email</td><td><?= htmlspecialchars($parsed['Email'] ?? '') ?></td></tr>
          <tr><td>Nom de l'Enfant</td><td><?= htmlspecialchars($parsed['Enfant'] ?? '') ?></td></tr>
          <tr><td>Âge</td><td><?= htmlspecialchars($parsed['Âge'] ?? '') ?></td></tr>
          <tr><td>Forfait</td><td><?= htmlspecialchars($parsed['Forfait'] ?? '') ?></td></tr>
          <tr><td>Activités</td><td><?= htmlspecialchars($parsed['Activités'] ?? '-') ?></td></tr>
          <tr><td>IP</td><td><?= htmlspecialchars($parsed['IP'] ?? '') ?></td></tr>
        </table>
        <?php if (!empty($parsed['Notes'])): ?>
          <div class="notes">📝 <?= htmlspecialchars($parsed['Notes']) ?></div>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</body>
</html>
