<?php
// save_reservation.php

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('❌ Requête invalide.');
}

// Basic sanitization helper
function clean($v) {
    return trim(filter_var($v ?? '', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
}

$parent   = clean($_POST['parent_name'] ?? '');
$email    = trim($_POST['email'] ?? '');
$child    = clean($_POST['child_name'] ?? '');
$age      = clean($_POST['child_age'] ?? '');
$package  = clean($_POST['package'] ?? '');
$notes    = clean($_POST['notes'] ?? '');

// --- Activities handling ---
$actsRaw  = $_POST['activities'] ?? [];
$activities = [];

if (is_array($actsRaw)) {
    foreach ($actsRaw as $a) {
        $activities[] = clean($a);
    }
} elseif (is_string($actsRaw) && $actsRaw !== '') {
    $activities[] = clean($actsRaw);
}

$activitiesList = implode(', ', $activities);

// Validate minimal required fields
$errors = [];
if ($parent === '')      { $errors[] = "Nom du Parent requis."; }
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) { $errors[] = "Adresse Email invalide."; }
if ($child === '')       { $errors[] = "Nom de l'Enfant requis."; }
if ($age === '')         { $errors[] = "Âge de l'Enfant requis."; }
if ($package === '')     { $errors[] = "Forfait requis."; }

if (!empty($errors)) {
    http_response_code(422);
    echo "<h2 style='font-family:Arial;color:#b91c1c;'>❌ Erreur de soumission</h2>";
    echo "<ul style='font-family:Arial;color:#7f1d1d;line-height:1.6'>";
    foreach ($errors as $e) { echo "<li>• " . htmlspecialchars($e) . "</li>"; }
    echo "</ul>";
    echo "<p><a href='javascript:history.back()'>⬅ Retour</a></p>";
    exit;
}

// Prepare destination folder
$baseDir = __DIR__ . DIRECTORY_SEPARATOR . 'data' . DIRECTORY_SEPARATOR . 'reservations';
if (!is_dir($baseDir)) {
    @mkdir($baseDir, 0755, true);
}

if (!is_dir($baseDir) || !is_writable($baseDir)) {
    http_response_code(500);
    exit("❌ Dossier non accessible en écriture: " . htmlspecialchars($baseDir));
}

// Build file content
$timestamp = date('Y-m-d H:i:s');
$ip        = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$ua        = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';

$content = "=== Nouvelle Réservation ===\n"
         . "Date/Heure: $timestamp\n"
         . "IP: $ip\n"
         . "Navigateur: $ua\n"
         . "------------------------------\n"
         . "Nom du Parent: $parent\n"
         . "Email: $email\n"
         . "Nom de l'Enfant: $child\n"
         . "Âge de l'Enfant: $age\n"
         . "Forfait: $package\n"
         . "Activités Préférées: " . ($activitiesList !== '' ? $activitiesList : '—') . "\n"
         . "Notes: " . ($notes !== '' ? $notes : '—') . "\n";

// Unique file name per submission
$filename = $baseDir . DIRECTORY_SEPARATOR . 'reservation-' . date('Ymd-His') . '-' . bin2hex(random_bytes(3)) . '.txt';

// Write file atomically
$ok = @file_put_contents($filename, $content, LOCK_EX);
if (!$ok) {
    http_response_code(500);
    exit("❌ Impossible d'écrire le fichier de réservation.");
}

// Simple success page
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="utf-8">
<title>Réservation enregistrée</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{font-family:Arial,system-ui,-apple-system,Segoe UI; background:#f8fafc; color:#0f172a; padding:40px}
.card{max-width:680px;margin:0 auto;background:#fff;border:1px solid #e5e7eb;border-radius:16px;padding:28px;box-shadow:0 10px 25px rgba(2,6,23,.08)}
.btn{display:inline-block;padding:12px 18px;border-radius:10px;text-decoration:none;background:linear-gradient(90deg,#2563eb,#7c3aed);color:#fff;font-weight:700}
.small{color:#475569}
pre{white-space:pre-wrap;background:#0f172a;color:#e2e8f0;padding:16px;border-radius:12px;overflow:auto}
</style>
</head>
<body>
  <div class="card">
    <h1>✅ Merci! Votre demande a été enregistrée.</h1>
    <p class="small">Nous vous contacterons très bientôt.</p>
    <p><a class="btn" href="index.html">⬅ Retour au site</a></p>
    <h3>Détails envoyés</h3>
    <pre><?=htmlspecialchars($content)?></pre>
  </div>
</body>
</html>
